<?php
/*

#####################################################################################
# NIST-developed software is provided by NIST as a public service. You may use, 
# copy and distribute copies of the software in any medium, provided that you 
# keep intact this entire notice. You may improve, modify and create derivative 
# works of the software or any portion of the software, and you may copy and 
# distribute such modifications or works. Modified works should carry a notice 
# stating that you changed the software and should note the date and nature of 
# any such change. Please explicitly acknowledge the National Institute of 
# Standards and Technology as the source of the software.
# 
# NIST-developed software is expressly provided “AS IS.” NIST MAKES NO WARRANTY 
# OF ANY KIND, EXPRESS, IMPLIED, IN FACT OR ARISING BY OPERATION OF LAW, 
# INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS 
# FOR A PARTICULAR PURPOSE, NON-INFRINGEMENT AND DATA ACCURACY. NIST NEITHER 
# REPRESENTS NOR WARRANTS THAT THE OPERATION OF THE SOFTWARE WILL BE 
# UNINTERRUPTED OR ERROR-FREE, OR THAT ANY DEFECTS WILL BE CORRECTED. NIST DOES 
# NOT WARRANT OR MAKE ANY REPRESENTATIONS REGARDING THE USE OF THE SOFTWARE OR 
# THE RESULTS THEREOF, INCLUDING BUT NOT LIMITED TO THE CORRECTNESS, ACCURACY, 
# RELIABILITY, OR USEFULNESS OF THE SOFTWARE.
# 
# You are solely responsible for determining the appropriateness of using and 
# distributing the software and you assume all risks associated with its use, 
# including but not limited to the risks and costs of program errors, compliance 
# with applicable laws, damage to or loss of data, programs or equipment, and the 
# unavailability or interruption of operation. This software is not intended to 
# be used in any situation where a failure could cause risk of injury or damage 
# to property. The software developed by NIST employees is not subject to 
# copyright protection within the United States.
#####################################################################################
Author: James R. Lyle
*/
$page_title = "SS Prep";
$page_h1 = "Overview of How to Get Ready to Run the Test Cases";
include "ft_ss_head.php";
?>
    <p>
	  <h2>Things you need to do to get ready to test a tool:</h2>
    <ul>
      <li>Obtain the String Search Tool you want to test.</li>
      <li>Select and download
	the string search test images from the <i>Federated Testing String Search</i>
	section of CFReDS.
	There are two test images (.dd files).
	one image is for testing search tools on
	Microsoft Windows type file systems (FAT, ExFAT 
	and NTFS) along with a block of unallocated storage space. The other 
	test image is for testing searching UNIX-like file systems (OSX, APFS and ext4).
	An HTML file is also included in the download. This file should be opened in
	a browser on the test computer. The file can be used for entering search
	target strings by copy and paste. This is helpful for entering non-English
	text as a search target string.
	</li>
	<li>From the list of defined string search test cases, select the test cases to run.
	You do not have to run all the test cases.
	You may want to omit any cases that are not relevent to the case work encountered
	in your lab or test a feature not supported by your tool. 
	For example, many tools do not support stemming search
	(FT-SS-09-Stem), so this case can be skipped
	most of the time.</li>
      <li>Install (if not already installed) the tool you want to
	 test on either a lab computer
	or a computer similar to the computers used in your lab. This is the 
	Test Computer.</li>
	<li>Make the test data set you downloaded from the CFReDS web-site readable by the tool
	to be tested by either copying the file to the
	test computer or locate the file on a removable drive
	that can be attached to the test computer where you are running the searches.</li>
	<li> You need to do some record
	keeping before you start running test cases.
	</ul>
	<ol style="margin-left: 40px">
	<li>Boot the Analysis Computer with the CFTT Federated Testing DVD.
	<li>Select <b>String Search</b>.
    <li>Select from the task menu: <b>Format FT-LOGS flash drive </b>to keep test logs.</li>
	<li>Select from the task menu: <b>Enter tool name and version</b> to record tool name and version.
	<li>Select from the task menu: <b>Identify Search Engine</b> to record the search engine being tested.
	This sets the search engine for the following tests until you select this task
	again and change the search engine.
	<li>Select from the task menu: <b>Select Test-Data Set</b> to record the data set (test image) being
	used.
	This sets the data set for the following tests until you select this task
	again and change the data set.
	</ol>

<br>
<?php
/*
*/
include "ft_ss_home_links.php";
?>
<br>
<form method="POST"
action="/stringsearch/ft_ss_home.php">
<input value="Press the button" type="submit"> </form>
<?php
	include "ft_ss_tail.php";
?>

